Rem
Rem Copyright (c) 2003, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      enq_ddllcr.sql - enqueues a DDL LCR for this sample.
Rem
Rem    DESCRIPTION
Rem      This script creates a DDL LCR and enqueues it to the queue 
Rem      MGWUSER.MGW_LCR_SRC.
Rem

set serveroutput on;
declare
    enqueue_options      dbms_aq.enqueue_options_t;
    message_properties   dbms_aq.message_properties_t;
    msgid                RAW(16);
    payload		 sys.anydata;
    lcrInText            varchar2(2000) := null;
    lcrInXml             XMLType;
    lcrInAnyData         Anydata;
begin
    lcrInText :=
      '<DDL_LCR xmlns="http://xmlns.oracle.com/streams/schemas/lcr"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xsi:schemaLocation="http://xmlns.oracle.com/streams/schemas/lcr
            http://xmlns.oracle.com/streams/schemas/lcr/streamslcr.xsd">

            <source_database_name>DBS1.REGRESS.RDBMS.DEV.US.ORACLE.COM</source_database_name>
            <command_type>CREATE TABLE</command_type>
            <current_schema>PINK_APP</current_schema>
            <ddl_text>CREATE TABLE with_clob
            (
              p  NUMBER,
              c1       CLOB,
              c2       CLOB,
              d  DATE
            ) </ddl_text>
            <object_type>TABLE</object_type>
            <object_owner>PINK_APP</object_owner>
            <object_name>WITH_CLOB</object_name>
            <logon_user>PINK_APP</logon_user>
            <base_table_owner>PINK_APP</base_table_owner>
            <base_table_name>WITH_CLOB</base_table_name>
            <transaction_id>4.1.186</transaction_id>
            <scn>205530</scn>
      </DDL_LCR>';

    lcrInXml := XMLType.createXML(lcrInText);
    lcrInAnyData := dbms_mgwmsg.xml_to_lcr(lcrInXml);
    
    -- Construct the message from its constituent parts.
    payload := lcrInAnyData;

    -- Enqueue the message.
    dbms_aq.enqueue(queue_name         => 'mgwuser.mgw_lcr_src',
                    enqueue_options    => enqueue_options,
                    message_properties => message_properties,
                    payload            => payload,
                    msgid              => msgid);
    commit;

    dbms_output.put_line('A DDL LCR has been sent to mgwuser.mgw_lcr.src');
  
end enqueue;
/
